﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class FindDirectoriesPanel
    Inherits FileSystemSample.TaskPanelBase

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents DirectoriesListBox As System.Windows.Forms.ListBox
    Friend WithEvents BackgroundWorker1 As System.ComponentModel.BackgroundWorker

    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        Me.DirectoriesListBox = New System.Windows.Forms.ListBox
        Me.BackgroundWorker1 = New System.ComponentModel.BackgroundWorker
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.Text = "Search a directory for subdirectories matching the wildcards provided.  The defau" & _
            "lt wildcard is ""*"""
        '
        'ExececuteMethodButton
        '
        '
        'ResetValuesButton
        '
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.DirectoriesListBox)
        Me.GroupBox2.Controls.SetChildIndex(Me.EndParenLabel, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ExececuteMethodButton, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ResetValuesButton, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.DirectoriesListBox, 0)
        '
        'DirectoriesListBox
        '
        Me.DirectoriesListBox.FormattingEnabled = True
        Me.DirectoriesListBox.Location = New System.Drawing.Point(14, 202)
        Me.DirectoriesListBox.Name = "DirectoriesListBox"
        Me.DirectoriesListBox.Size = New System.Drawing.Size(558, 173)
        Me.DirectoriesListBox.TabIndex = 5
        '
        'BackgroundWorker1
        '
        Me.BackgroundWorker1.WorkerReportsProgress = False
        Me.BackgroundWorker1.WorkerSupportsCancellation = False
        '
        'FindDirectoriesPanel
        '
        Me.Name = "FindDirectoriesPanel"
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Shared panelInstance As FindDirectoriesPanel
    Friend WithEvents dirChooser As New DirectoryChooser
    Friend WithEvents recurseComboBox As New ComboBox()
    Friend WithEvents wildCardsTextBox As New TextBox()

    Private searchResults As System.Collections.ObjectModel.ReadOnlyCollection(Of String)
    Private directory As String
    Private recurse As Boolean
    Private wildCards As String()

    ''' <summary>
    ''' 返回该面板的全局实例
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As FindDirectoriesPanel
        If (panelInstance Is Nothing) Then
            panelInstance = New FindDirectoriesPanel
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板，并为 My.Computer.FileSystem.GetDirectories 的每个参数创建一个控件
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub FindDirectories_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("directory", dirChooser)
        MyBase.AddParameter("recurse", recurseComboBox)
        MyBase.AddParameter("wildCards", wildCardsTextBox)
    End Sub


    ''' <summary>
    ''' 用所需控件创建该面板。
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.GetDirectories("
        dirChooser.Reset()
        recurseComboBox.Items.AddRange(New String() {"True", "False"})
        recurseComboBox.AutoSize = True
        recurseComboBox.SelectedItem = "False"

        wildCardsTextBox.AutoSize = True
        wildCardsTextBox.Text = "*"
    End Sub

    ''' <summary>
    ''' 获取与所提供的通配符匹配的所有目录。由于执行此操作可能需要很长时间，因此我们使用
    ''' 后台辅助线程在后台执行此操作。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        Me.DirectoriesListBox.Items.Clear()
        Me.DirectoriesListBox.Items.Add("Searching " & Me.dirChooser.Directory & "...")

        directory = Me.dirChooser.Directory
        recurse = Boolean.Parse(CType(Me.recurseComboBox.SelectedItem, String))
        wildCards = New String() {Me.wildCardsTextBox.Text}

        Me.BackgroundWorker1.RunWorkerAsync()
    End Sub

    ''' <summary>
    ''' 将这些控件重置为它们的默认值。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub

    ''' <summary>
    ''' 在所有子目录中搜索与所提供的通配符匹配的目录名。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub BackgroundWorker1_DoWork(ByVal sender As Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork
        Try
            If (recurse) Then
                searchResults = My.Computer.FileSystem.GetDirectories(directory, FileIO.SearchOption.SearchAllSubDirectories, wildCards)
            Else
                searchResults = My.Computer.FileSystem.GetDirectories(directory, FileIO.SearchOption.SearchTopLevelOnly, wildCards)
            End If

        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ''' <summary>
    ''' 所有操作均已完成，因此可以用这些结果更新该 UI。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub BackgroundWorker1_RunWorkerCompleted(ByVal sender As Object, ByVal e As System.ComponentModel.RunWorkerCompletedEventArgs) Handles BackgroundWorker1.RunWorkerCompleted
        Me.DirectoriesListBox.Items.Clear()
        If (searchResults Is Nothing Or searchResults.Count < 1) Then
            Me.DirectoriesListBox.Items.Add("<No directories found.>")
        Else
            For Each searchResult As String In searchResults
                Me.DirectoriesListBox.Items.Add(searchResult)
            Next
        End If
    End Sub

End Class
